IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO]') 
					AND type in (N'U')) 
BEGIN  

	CREATE TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO](

		[CD_EMP] [int] NOT NULL			CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_CD_EMP]			DEFAULT ((0)),
	 	[CD_AGD_RESSUP]	[int] NOT NULL	CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_CD_AGD_RESSUP]	DEFAULT ((0)),
		[CD_FILIAL_DEPO] [int] NOT NULL CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_CD_FILIAL_DEPO]	DEFAULT ((0)),
		[CD_CTR_DEPO]	[int] NOT NULL	CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_CD_CTR_DEPO]		DEFAULT ((0)), 
		[ORDEM_CD]		[int] NOT NULL	CONSTRAINT [DF_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_ORDEM_CD]		DEFAULT ((0)), 

	 CONSTRAINT [PK_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO] PRIMARY KEY CLUSTERED 
	(	[CD_EMP] ASC , 
		[CD_AGD_RESSUP]  ASC,
		[CD_FILIAL_DEPO] ASC,
		[CD_CTR_DEPO] ASC   )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, 
	ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]
	 

	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO]  WITH CHECK 
		ADD  CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_EST_PROD_RESSUP_AGENDAMENTO] FOREIGN KEY([CD_EMP],[CD_FILIAL_DEPO], [CD_AGD_RESSUP])
	REFERENCES [dbo].[EST_PROD_RESSUP_AGENDAMENTO] ([CD_EMP],[CD_FILIAL_DEPO], [CD_AGD_RESSUP]) 

	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO] 
		CHECK CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_EST_PROD_RESSUP_AGENDAMENTO]

	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO]  WITH CHECK 
		ADD  CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_PRC_FILIAL_DEPOSITO] FOREIGN KEY([CD_CTR_DEPO])
	REFERENCES [dbo].[PRC_FILIAL_DEPOSITO] ([CD_CTR_DEPO]) 

	ALTER TABLE [dbo].[EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO] 
		CHECK CONSTRAINT [FK_EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO_PRC_FILIAL_DEPOSITO]
 END
